// KEYBOARD.C - L[{[h

#include "common.h"
#include "joystick.h"
#include "prop.h"
#include "keyboard.h"
#include "../x68k/mfp.h"

BYTE	KeyBufWP;
BYTE	KeyBufRP;
BYTE	KeyBuf[KeyBufSize];
BYTE	KeyEnable = 1;
BYTE	KeyIntFlag = 0;

extern BYTE traceflag;

void Keyboard_Init(void)
{
	KeyBufWP = 0;
	KeyBufRP = 0;
	ZeroMemory(KeyBuf, KeyBufSize);
	KeyEnable = 1;
	KeyIntFlag = 0;
}



// ----------------------------------
//	ā[Ԃ
// ----------------------------------
BYTE KeyTable[512]={	// WinVKR[hi9rbgڂ͊gR[hrbgj  X68k̃L[R[h
/*00*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
/*10*/	0x70, 0x71, 0x55, 0x61, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x56, 0x00, 0x00,
/*20*/	0x35, 0x38, 0x39, 0x3a, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x37, 0x00,
/*30*/	0x0b, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*40*/	0x00, 0x1e, 0x2e, 0x2c, 0x20, 0x13, 0x21, 0x22, 0x23, 0x18, 0x24, 0x25, 0x26, 0x30, 0x2f, 0x19,
/*50*/	0x1a, 0x11, 0x14, 0x1f, 0x15, 0x17, 0x2d, 0x12, 0x2b, 0x16, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,
/*60*/	0x4f, 0x4b, 0x4c, 0x4d, 0x47, 0x48, 0x49, 0x43, 0x44, 0x45, 0x41, 0x46, 0x00, 0x42, 0x51, 0x40,
/*70*/	0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*80*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*90*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*A0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*B0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x27, 0x31, 0x0C, 0x32, 0x33,
/*C0*/	0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*D0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x0e, 0x29, 0x0d, 0x00,
/*E0*/	0x00, 0x00, 0x34, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*F0*/	0x00, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*00*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x00,
/*10*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*20*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x3c, 0x3d, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*30*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*40*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*50*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*60*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*70*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*80*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*90*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*A0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*B0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*C0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*D0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*E0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*F0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


BYTE KeyTableMaster[512]={	// WinVKR[hi9rbgڂ͊gR[hrbgj  X68k̃L[R[h
/*00*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
/*10*/	0x70, 0x71, 0x55, 0x61, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x56, 0x00, 0x00,
/*20*/	0x35, 0x38, 0x39, 0x3a, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x37, 0x00,
/*30*/	0x0b, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*40*/	0x00, 0x1e, 0x2e, 0x2c, 0x20, 0x13, 0x21, 0x22, 0x23, 0x18, 0x24, 0x25, 0x26, 0x30, 0x2f, 0x19,
/*50*/	0x1a, 0x11, 0x14, 0x1f, 0x15, 0x17, 0x2d, 0x12, 0x2b, 0x16, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,
/*60*/	0x4f, 0x4b, 0x4c, 0x4d, 0x47, 0x48, 0x49, 0x43, 0x44, 0x45, 0x41, 0x46, 0x00, 0x42, 0x51, 0x40,
/*70*/	0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*80*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*90*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*A0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*B0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x27, 0x31, 0x0C, 0x32, 0x33,
/*C0*/	0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*D0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x0e, 0x29, 0x0d, 0x00,
/*E0*/	0x00, 0x00, 0x34, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*F0*/	0x00, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*00*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x00,
/*10*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*20*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x3c, 0x3d, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*30*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*40*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*50*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*60*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*70*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*80*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*90*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*A0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*B0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*C0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*D0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*E0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*F0*/	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// ----------------------------------
//	WM_KEYDOWN`
// ----------------------------------
void Keyboard_KeyDown(WORD wp, DWORD lp)
{
	BYTE code = KeyTable[(wp&0xff)|((lp>>16)&0x0100)];
	BYTE newwp;
//	if (lp&0x40000000L) return;			// Repeat
	if (code)
	{
		newwp = ((KeyBufWP+1)&(KeyBufSize-1));
		if (newwp != KeyBufRP)
		{
			KeyBuf[KeyBufWP] = code;
			KeyBufWP = newwp;
		}
	}

	switch(wp)
	{
	case VK_UP:
		if (!(JoyKeyState&JOY_DOWN))
			JoyKeyState |= JOY_UP;
		break;
	case VK_DOWN:
		if (!(JoyKeyState&JOY_UP))
			JoyKeyState |= JOY_DOWN;
		break;
	case VK_LEFT:
		if (!(JoyKeyState&JOY_RIGHT))
			JoyKeyState |= JOY_LEFT;
		break;
	case VK_RIGHT:
		if (!(JoyKeyState&JOY_LEFT))
			JoyKeyState |= JOY_RIGHT;
		break;
	case 'Z':
		if (Config.JoyKeyReverse)
			JoyKeyState |= JOY_TRG2;
		else
			JoyKeyState |= JOY_TRG1;
		break;
	case 'X':
		if (Config.JoyKeyReverse)
			JoyKeyState |= JOY_TRG1;
		else
			JoyKeyState |= JOY_TRG2;
		break;
	}
/*{
FILE *fp;
fp=fopen("_key.txt", "a");
fprintf(fp, "KeyDn  WP:%04X  LP:%08X  Key:%02X\n", wp, lp, code);
fclose(fp);
}*/		//Opɂ

}

// ----------------------------------
//	WM_KEYUP
// ----------------------------------
void Keyboard_KeyUp(WORD wp, DWORD lp)
{
	BYTE code = KeyTable[(wp&0xff)|((lp>>16)&0x0100)];
	BYTE newwp;
	if (code)
	{
		newwp = ((KeyBufWP+1)&(KeyBufSize-1));
		if (newwp != KeyBufRP)
		{
			KeyBuf[KeyBufWP] = (code|0x80);
			KeyBufWP = newwp;
		}
	}

	switch(wp)
	{
	case VK_UP:
		JoyKeyState &= ~JOY_UP;
		break;
	case VK_DOWN:
		JoyKeyState &= ~JOY_DOWN;
		break;
	case VK_LEFT:
		JoyKeyState &= ~JOY_LEFT;
		break;
	case VK_RIGHT:
		JoyKeyState &= ~JOY_RIGHT;
		break;
	case 'Z':
		if (Config.JoyKeyReverse)
			JoyKeyState &= ~JOY_TRG2;
		else
			JoyKeyState &= ~JOY_TRG1;
		break;
	case 'X':
		if (Config.JoyKeyReverse)
			JoyKeyState &= ~JOY_TRG1;
		else
			JoyKeyState &= ~JOY_TRG2;
		break;
	}

/*{
FILE *fp;
fp=fopen("_key.txt", "a");
fprintf(fp, "KeyUp  WP:%04X  LP:%08X  Key:%02X\n", wp, lp, code);
fclose(fp);
}*/		//Opɂ
}

// ----------------------------------
//	Key Check
//	1t[4i2400bps/10bit/60fpsƂ΁AjĂ΂āAMFPɃf[^𑗂
// ----------------------------------

void Keyboard_Int(void)
{
	if (KeyBufRP != KeyBufWP)
	{
		if (!KeyIntFlag)
		{
			LastKey = KeyBuf[KeyBufRP];
			KeyBufRP = ((KeyBufRP+1)&(KeyBufSize-1));
			KeyIntFlag = 1;
			MFP_Int(3);
/*{
FILE *fp;
fp=fopen("_key.txt", "a");
fprintf(fp, "KeyInt  BufWP:%d  BufRP:%d  Buf[RP-1]:%02X\n", KeyBufWP, KeyBufRP, KeyBuf[((KeyBufRP-1)&0x3f)]);
fclose(fp);
}*/		//Opɂ
		}
	}
	else if (!KeyIntFlag)
	{
		LastKey = 0;
		//KeyReadFlag = 0;
	}
}
